# Version Control

The previous tasks were already on the GitLab service. This time, we'll get acquainted with version control and GitLab on the side.

The purpose of version control is mainly to manage different versions of software or source code. Of course, it is also used for example for different versions of documents, but let's look at the issue this time mainly from the perspective of software code.

## What version?

When we talk about a version, the first thing that comes to mind is different versions of some program, that is, for example, what the program was like before the update and what it is like after the update. These are also versions, but strictly speaking, we could talk about **releases** in this case. In the context of version control, a version refers to the code after any change, such as:

* You've added a new function -> new version

* You've fixed a programming error -> new version

* You've updated the program's output, e.g., to start with a capital letter -> version.

Not all of these are necessarily published separately. The actual program that ends up with users may be a version that's published after several changes.

## About Software Development

Nowadays, many programs are really extensive. Almost without exception, every program has numerous different developers, although you can still make programs completely alone. But how can many developers modify the same code? If both have their own copy, how is the code combined? And if both have modified the same part of the code in different ways, which one is chosen?

# The Purpose of Version Control

The purpose of version control is first and foremost to preserve the source code and other resources of the program. In addition, countless different versions can be stored in version control, meaning that practically after any minor change, the changes are saved in version control. With the help of version control, you can answer questions such as:

* What is the latest working version of the code?

* Where can I get the latest version of the code for my computer?

* What's the latest version that's ready for release?

* Who has coded what?

In addition, services operating on the internet typically include other tools as well.

* Automatic testing, deployment, etc. (CI/CD)

* Issue tracker, i.e., tracking of bug reports and a discussion area related to them.

* Roadmaps, i.e., what tasks are still to be done for the program or part of it to be completed

# Git

Version control tools come in many different types, but nowadays **git** has displaced most of them, although other tools still have their user base. The first version of Git was developed by Linus Torvalds, who was fed up with the deficiencies of existing tools and needed a better version control system for the development of the Linux kernel.


## The Basic Idea of Git


Git stores the latest version of the code in a repository, or *repo*. When a change is made to the code, the user can save the changes to their *repo*.


The basic idea of Git is quite clear; the user can return to any old version at any time. If the new features don't work, or the code just doesn't get finished in one evening but it still needs to be used, the user always has access to the old, working version.


Git also allows for branching of development work to multiple different branches. For example, a coder can make changes to their code and gradually develop a new feature. However, the development work can take time and in the middle of it all, it may turn out that the latest release has a programming error that needs to be fixed and published immediately. The current version is completely broken and unfinished, but luckily it's in its own branch. The programmer can return to the main branch, make changes, and publish a new version. The more advanced development of new features is safely stored in its own branch. Thus, new features can be added in parallel no matter how much, so that all team members work on different features. Of course, eventually, the aim would be to get all changes into use, i.e., different development branches are meant to be merged back into the main branch.


## The Stages of Using Git


When a project is managed with Git, information can be in several different places and states.


<img src="pictures/git1.png" alt="">


### Working Directory


The programmer makes changes to their project, in the directory they are working in, i.e., the working directory. This is the directory where files are stored and, if desired, they can be clicked on with the mouse in the usual way, or edited with the help of a development environment or editor.


### Staging

Staging is a kind of waiting area where files can be added after they have changed. You can move changed files to the staging area before actually implementing the changes. You can continue to edit files, but all changes must be moved separately to the staging area to wait.

This waiting area is one of Git's strengths compared to other tools: not every possible change has to be saved at once, but only certain changes can be selected.

### Local Repository

If you want to confirm the changes you've made, you can do the so-called **commit** operation. Commit makes the changes to the files in the staging area final and moves them into version control.

So Git doesn't save every possible change, but only those for which the user performs a commit operation. So if you edit your code over several days and use the Save button of your program, these won't automatically go into version control, and they certainly aren't meant to.

### Remote Repository

Git works best when it is connected to the network. With Git, you can store source code so that it is always available to all authorised users. This way, you can conveniently store code and all its history so that you can access it from anywhere. In addition, several people can work on the same project, as tracking and merging changes made by different users into the project can be conveniently done with Git.

Now it's time to install Git and make sure the Unix command line is familiar. Let's move on to the next section, i.e., [the basic operations of Git](basics_of_git.md).