# Remote Repository

It's generally advisable to create a copy of your repository to a version control service. This allows you to conveniently transfer it from, say, your laptop to your desktop, or to share it with a friend.

Log in to the service at https://gitlab.utu.fi via your browser.

Next, let's create a new repository:

Select **New project → Create blank project**

Name your project `demoproject` and leave the other settings unchanged:

Then click on **Create project.**

**NOTE!** Make sure you do not create a README file in the repository (i.e., make sure the option is deselected when you choose Create project).

Next, we'll create a link to the newly created remote repository. Copy the remote address from **Clone → HTTPS** (or write it down as shown in the picture, but replace it with your own username).

Enter the command

`$ git remote add origin https://gitlab.utu.fi/yourusername/demoproject`

This command means that a new remote repository is being added, named "origin", and is being assigned the desired address.

Now, the contents of the repository can be sent to the remote repository using the push command. Enter the command

`$ git push origin master`

Git will likely ask you to enter your username and password. Enter your username without the @utu.fi suffix. Windows may automatically save these to the Credential Manager, so you won't have to enter them next time.

Switch back to the Gitlab website in your browser. Now, the change you just made in the repository should be visible there (refresh the page first):

Let's make one more change to a file so that the process becomes more familiar:

Modify the contents of the MessageTimes10.java file in some way - add a comment, for example

Add the file with the command

`$ git add MessageTimes10.java`

Make a commit with the command

`$ git commit -m "added a comment"`

Push the commit to the remote repository with the command

`$ git push origin master`

If you enter the command

`$ git push --set-upstream origin master`

git will set the master branch as the default, meaning `git push` will push changes to the master branch by default (or to any other branch you choose).

Make sure that the change is visible on the Gitlab site

# Cloning a Repository

You can clone or copy a public repository that's online to your own computer. Let's try this out.

First, fetch the address of the repository you want to clone from

https://gitlab.utu.fi/ertaka/esimerkkiprojekti

The content of the example project does not matter in this case. The project linked is in Finnish, and it's main point is to show that you can save any file types (e.g. `.pdf`, `.png`...) to a repository and are not restricted in only saving code files (e.g. `.java` or `.py`).

On the page, there's a blue button labeled Clone. Click it and copy the address from Clone with HTTPS

Go back to the console and move out of the current repository. Enter the command

,`$ git clone <address of the repository to clone>`



Note! In the Windows version of Git Bash, you can paste code by pressing SHIFT + INSERT.


Inspect the contents of the cloned folder. At least read the `README.md` file


Try the following next:


1. Create a new repository on the Gitlab page

2. Clone it to your own computer

3. Add some file or files to the cloned folder

4. Add the changes (add), make a commit and push

5. Verify that the changes are also visible in Gitlab




# Useful links:


There are various graphical tools for Git, of which Sourcetree is very popular:


<https://www.sourcetreeapp.com/>


GitHub offers a handy cheat sheet for Git commands:


<https://education.github.com/git-cheat-sheet-education.pdf>


Explore the contents of the cloned folder. At least read the `README.md` file.

Try the following:

1. Create a new repository on the Gitlab page

2. Clone it to your own computer

3. Add a file or files to the cloned folder

4. Add the changes (add), make a commit and push

5. Check that the changes are also visible in Gitlab

# Useful Links:

There are various graphical tools available for Git, of which Sourcetree is very popular:

<https://www.sourcetreeapp.com/>

GitHub offers a handy cheat sheet for Git commands:

<https://education.github.com/git-cheat-sheet-education.pdf>

