# Basics of Git

## Starting Git and Basic Settings

Launch the Git bash program (on Windows) or terminal / console (on Mac / Linux).

Before using Git for the first time, you need to provide Git with your user information. This links the changes you make to you.

`$ git config --global user.email "you@example.com"`

`$ git config --global user.name "Your Name"`

## Creating a Git Repository

Starting to use Git is straightforward. Its use can be started either in an empty directory or in an already existing project. For practice, let's create a directory:

`$ mkdir exercise`

and navigate to it:

`$ cd exercise`

Let's start by setting up a new git repository:

```
$ git init
Initialized empty Git repository in /home/jubery/Documents/Github/exercise/.git/
```

Now Git will start tracking the content of this directory. All changes and old versions are saved in a directory named `.git` which is hidden by default.

## Examining the Git Repository

Next, let's run the command

`$ git status`

Git tells us that the current branch is master, nothing has been done yet, and there are no tracked files.

Add a file to the directory called `Example.java`:

```java
public class Example {
    public static void main(String[] args) {
        System.out.println("Version control works!");
    }
}
```

The content of the folder should look like this when you run the command

`$ ls -la`

Now when you run the command

`$ git status`

Git tells us that there is a file in the directory that is currently not being tracked (i.e. untracked files):

```
$ git status
On branch master

No commits yet

Untracked files:
  (use "git add <file>..." to include in what will be committed)

        Example.java
```

In summary, Git tells us the following:

* We are on a branch named master (main branch)

* No _commits_ i.e. no permanent changes have been made yet

* Untracked files: there are new files whose changes git does not yet track in any way.

As the hint given by Git suggests, we could now add these files to be tracked by Git:

Let's run the command

`$ git add Example.java`

and then again

`$ git status`

```
$ git status
On branch master,No commits yet

Changes to be committed:

(use "git rm --cached <file>..." to unstage)

new file:   Example.java

```

This shows the same information as above, but now listed are *Changes to be committed* i.e., changes that are awaiting confirmation. Let's save these changes and at the same time record a message about what was just done.

`$ git commit -m "Program that prints a message on the screen"`

Here:

* The operation is defined as commit, i.e., "committing" to changes
* `-m` is short for `message` and it defines that the next parameter is a message that tells what the just made change is about.
* Typically, the first commit is just named "initial commit". You can of course use Finnish if you want.

Actually, so far you can get a long way with simple little projects:

* Code something
* Do `git add --all`
* Do `git commit -m "this and that changed"`



The introductory material introduced a simple add/commit command chain. This is a direct continuation of the previous tasks, so make sure you have a repository that has the `Example.java` file and the commits made to it.


## Making changes

Let's change the `Example.java` file by adding lines to it that print the message 10 times instead of once:
```java

public class Example {

    public static void main(String[] args) {

        for (int i=0; i<10; i++) {
            System.out.println("Version control works!");
        }
    }
}
```

Now the command

`$ git status`

tells that the file has changed:

<img src="pictures/git2.png" alt="">



With the command 

`$ git diff`

we can examine the changes made:

Now git shows which lines have been removed, which lines are new, and the unchanged lines are in grey. If the file is particularly long, only the changed parts are shown instead of the whole file.


Let's send the changed file to the repository:

`$ git add Example.java`

`$ git commit -m "Program prints the message ten times"`

Let's try to rename the file again. Let's change the file name to `MessageTimes10.java` and give the command again 

`$ git status`


<img src="pictures/change1.png" alt="">

Since Git does not understand the changed file name, it shows two changes. The change must be sent to the repository either by adding both files separately

`$ git add Example.java`

`$ git add MessageTimes10.java`

Or by adding all changed files by typing

`$ git add --all`

Note that the latter always adds all files - even those you might not want to add. Perhaps using `...add *.java` or some wildcard would be a better idea.

Status can tell that the file name has changed:

`$ git status`

<img src="pictures/rename.png" alt="">

Let's make another commit:

`$ git commit -m "Renamed the file"`

Now you could view all changes in different ways:

`$ git log`

`$ git log --graph`

`$ git log --graph --oneline`

Many of these are only essential when there are multiple branches in development.

Next, we'll look at [remote repositories](remote_repositories.md).

