use core::fmt::{Arguments, Write};
use spin::{Lazy, Mutex};
use uart_16550::SerialPort;
use x86_64::instructions::interrupts;

//

static SERIAL1: Lazy<Mutex<SerialPort>> = Lazy::new(|| {
    let mut serial_port = unsafe { SerialPort::new(0x3F8) };
    serial_port.init();
    Mutex::new(serial_port)
});

static SERIAL_ERR: &str = "Printing to serial failed";

//

#[doc(hidden)]
pub fn _print(args: Arguments) {
    interrupts::without_interrupts(|| {
        let mut s = SERIAL1.lock();
        s.write_fmt(args).expect(SERIAL_ERR);
    });
}

#[doc(hidden)]
pub fn _println(args: Arguments) {
    interrupts::without_interrupts(|| {
        let mut s = SERIAL1.lock();
        s.write_fmt(args).expect(SERIAL_ERR);
        s.write_char('\n').expect(SERIAL_ERR);
    });
}

//

#[macro_export]
macro_rules! serial_print {
    ($($arg:tt)*) => {
        $crate::serial::_print(format_args!($($arg)*));
    };
}

#[macro_export]
macro_rules! serial_println {
    ($($arg:tt)*) => {
        $crate::serial::_println(format_args!($($arg)*));
    };
}
