#![no_std]
#![no_main]
#![feature(custom_test_frameworks)]
#![feature(iter_array_chunks)]
#![test_runner(test_fw::test_runner)]
#![reexport_test_harness_main = "test_main"]

//

use bootloader::{entry_point, BootInfo};

//

mod serial;
#[cfg(test)]
mod test_fw;

//

#[cfg(not(test))]
#[panic_handler]
fn panic(_: &core::panic::PanicInfo) -> ! {
    halt()
}

entry_point!(kernel_main);
fn kernel_main(i: &mut BootInfo) -> ! {
    if let Some(fb) = i.framebuffer.as_mut() {
        fb.buffer_mut().fill(0x40);
    }

    #[cfg(test)]
    test_main();

    halt()
}

fn halt() -> ! {
    loop {
        x86_64::instructions::hlt();
    }
}

#[cfg(test)]
mod tests {
    // a test to test if tests work
    #[test_case]
    fn test_test() {
        assert_eq!(1, 1)
    }

    /* #[test_case]
    fn test_test_fail() {
        assert_eq!(1, 0)
    } */
}
