import pygame

def alusta():
    """ Alustaa pygame ikkunan ja palauttaa näyttöolion """
    pygame.init()
    naytto = pygame.display.set_mode((640, 480))
    return naytto

def piirra_pallo(naytto, x: int, y: int):
    """ Piirtää ruudulle pallon annettuihin koordinaatteihin """
    # Parametrit: näyttöolio, väri (r,g,b), x- ja y-koordinaatit
    # tuplena, koko x-suunnassa, koko y-suunnassa
    pygame.draw.circle(naytto, (255,0,0), (x, y), 40, 40)



naytto = alusta()

# Pallon aloituskoordinaatit
pallo_x = 0
pallo_y = 200

# alustetaan ajastin
ajastin = pygame.time.Clock()

# Pygamen pääsilmukka, jossa odotetaan ikkunan sulkeutumista
while True:
    for tapahtuma in pygame.event.get():
        if tapahtuma.type == pygame.QUIT:
            exit()
            
    # Piirretään pallo nykyiseen paikkaan
    naytto.fill((0,0,0))
    piirra_pallo(naytto, pallo_x, pallo_y)
    
    pygame.display.flip()
    
    # Siirretään palloa 1 pikseli oikealle
    pallo_x += 1
    
    # Jos päästiin reunasta yli, aloitetaan uudestaan vasemmalta
    if pallo_x == 680:
        pallo_x = 0
        
    # Odotetaan  hetki
    ajastin.tick(250)

