#include <ftl/codecs/writer.hpp>

#include <tuple>

using ftl::codecs::Writer;

Writer::Writer(std::ostream &s) : stream_(&s) {}

Writer::~Writer() {

}

bool Writer::begin() {
	ftl::codecs::Header h;
	h.version = 0;
	(*stream_).write((const char*)&h, sizeof(h));
	return true;
}

bool Writer::end() {
	return true;
}

bool Writer::write(const ftl::codecs::StreamPacket &s, const ftl::codecs::Packet &p) {
	auto data = std::make_tuple(s,p);
	msgpack::pack(buffer_, data);
	(*stream_).write(buffer_.data(), buffer_.size());
	buffer_.clear();
	return true;
}
