#include <ftl/codecs/reader.hpp>

#include <tuple>

using ftl::codecs::Reader;
using ftl::codecs::StreamPacket;
using ftl::codecs::Packet;
using std::get;

Reader::Reader(std::istream &s) : stream_(&s) {

}

Reader::~Reader() {

}

bool Reader::begin() {
	ftl::codecs::Header h;
	(*stream_).read((char*)&h, sizeof(h));
	if (h.magic[0] != 'F' || h.magic[1] != 'T' || h.magic[2] != 'L' || h.magic[3] != 'F') return false;
	return true;
}

bool Reader::read(int64_t ts, const std::function<void(const ftl::codecs::StreamPacket &, const ftl::codecs::Packet &)> &f) {
	while (stream_->good()) {
		if (buffer_.nonparsed_size() == 0) {
			buffer_.reserve_buffer(100000);
			stream_->read(buffer_.buffer(), 100000);
			//if (stream_->bad()) return false;

			int bytes = stream_->gcount();
			if (bytes == 0) return false;
			buffer_.buffer_consumed(bytes);
		}

		msgpack::object_handle msg;
		if (!buffer_.next(msg)) continue;

		msgpack::object obj = msg.get();
		std::tuple<StreamPacket,Packet> data;
		obj.convert(data);

		f(get<0>(data),get<1>(data));
	}

	return false;
}

bool Reader::end() {
	return true;
}
