#ifndef _FTL_CUDA_CARVER_HPP_
#define _FTL_CUDA_CARVER_HPP_

#include <ftl/cuda_common.hpp>
#include <ftl/cuda_matrix_util.hpp>
#include <ftl/rgbd/camera.hpp>

namespace ftl {
namespace cuda {

/**
 * Carve `in` using `ref` as visibility reference.
 */
void depth_carve(
	cv::cuda::GpuMat &in,
	const cv::cuda::GpuMat &ref,
	const cv::cuda::GpuMat &in_colour,
	const cv::cuda::GpuMat &ref_colour,
	cv::cuda::GpuMat &colour_scale,
	const float4x4 &transform,
	const ftl::rgbd::Camera &incam,
	const ftl::rgbd::Camera &refcam,
	cudaStream_t stream);

void apply_colour_scaling(
	const cv::cuda::GpuMat &scale,
	cv::cuda::GpuMat &colour,
	int radius,
	cudaStream_t stream);

void mls_reduce(
	const cv::cuda::GpuMat &centroid,
	const cv::cuda::GpuMat &normals,
	const cv::cuda::GpuMat &contrib,
	cv::cuda::GpuMat &normals_out,
	cv::cuda::GpuMat &depth,
	const ftl::rgbd::Camera &camera,
	cudaStream_t stream
);

void mls_gather(
	const cv::cuda::GpuMat &normals_in,		// Source frame
	cv::cuda::GpuMat &normals_out,
	const cv::cuda::GpuMat &depth_origin,  // Rendered image
	const cv::cuda::GpuMat &depth_in,
	cv::cuda::GpuMat &centroid_out,
	cv::cuda::GpuMat &contrib_out,
	float smoothing,
	const float4x4 &o_2_in,
	const float4x4 &in_2_o,
	const ftl::rgbd::Camera &camera_origin,  // Virtual camera
	const ftl::rgbd::Camera &camera_in,
	cudaStream_t stream
);

}
}

#endif