#include <ftl/operators/segmentation.hpp>
#include "segmentation_cuda.hpp"

using ftl::operators::CrossSupport;
using ftl::codecs::Channel;

CrossSupport::CrossSupport(ftl::Configurable *cfg) : ftl::operators::Operator(cfg) {

}

CrossSupport::~CrossSupport() {

}

bool CrossSupport::apply(ftl::rgbd::Frame &in, ftl::rgbd::Frame &out, ftl::rgbd::Source *s, cudaStream_t stream) {
	ftl::cuda::support_region(
        in.createTexture<uchar4>(Channel::Colour),
		out.createTexture<uchar4>(Channel::Colour2, ftl::rgbd::Format<uchar4>(in.get<cv::cuda::GpuMat>(Channel::Colour).size())),
		config()->value("tau", 5),
        config()->value("v_max", 10),
        config()->value("h_max", 10), 0
	);

	return true;
}