import React from 'react';

const Course = (props) => (
    <div>
        <Header name={props.course.name}/>
        <Contents parts={props.course.parts}/>
    </div>
);

const Header = (props) => <h1>{props.name}</h1>;

const Contents = (props) => (
<div>
    {props.parts.map(part =>
    <Part key={part.id} part={part}/>
    )}
    <Total parts={props.parts}/>
</div>
);

const Part = (props) => (
    <p>{props.part.name + " " + props.part.exercises}</p>
);

const Total = (props) => (
    <p>Total: {countTotalExercises(props.parts)}</p>
);

function countTotalExercises (list)
{
let sum = 0;
list.forEach(part => {
    sum += part.exercises;
});
return sum;
}

export default Course;