import java.util.ArrayList;

public class Muistivihko {

    private String nimi;
    private String omistaja;
    private ArrayList<String> muistiinpanot;

    public Muistivihko(String nimi, String omistaja) {
        this.nimi = nimi;
        this.omistaja = omistaja;
        muistiinpanot = new ArrayList<>();
    }

    /**
     * Havainnointimetodi, joka palauttaa objektille asetetun nimen.
     *
     * @return palauttaa objektille asetetun nimen
     */
    public String getNimi() {
        return nimi;
    }


    /**
     * Asetusmetodi, joka ottaa parametriksi String -muodossa nimen, ja asettaa sen olion nimeksi.
     *
     * @param nimi oliolle asetettava nimi
     */
    public void setNimi(String nimi) {
        this.nimi = nimi;
    }

    /**
     * Havainnointimetodi, joka palauttaa objektille asetetun omistajan.
     *
     * @return palauttaa objektille asetetun omistajan.
     */
    public String getOmistaja() {
        return omistaja;
    }

    /**
     * Asetusmetodi, joka ottaa parametriksi String-muodossa omistajan, ja asettaa sen olion omistajaksi.
     * @param omistaja oliolle asetettava omistaja
     */
    public void setOmistaja(String omistaja) {
        this.omistaja = omistaja;
    }

    /**
     * Metodi, joka lisää muistikirjaan viestin.
     *
     * @param viesti ottaa vastaan parametriksi String-muodossa viestin, joka lisätään muistikirja-olioon.
     */
    public void lisaaMuistiinpano(String viesti) {
        this.muistiinpanot.add(viesti);
    }

    /**
     * Metodi, joka palauttaa int-tyyppisenä muuttujana muistiinpanojen lukumäärän muistikirjassa.
     *
     * @return palauttaa int-tyyppisen muuttujan ja kertoo, kuinka monta muistiinpanoa muistikirja-olioon on tallennettu.
     */
    public int muistiinpanoja() {
        return muistiinpanot.size();
    }


    /**
     *Metodi, joka tulostaa yksittäiset muistikirja-olioon lisätyt muistiinpanot yksi kerrallaan.
     */
    public void tulostaMuistiinpanot() {
        for(String viesti : muistiinpanot) {
            System.out.println(viesti);
        }
    }
}

