import java.util.ArrayList;
/**
* Luokka mallintaa muistivihkoa, jolla on nimi sekä omistaja.  
* Muistivihkoon voi lisätä muistiinpanoja sekä tulostaa kirjatut muistiinpanot.
* Myös muistiinpanojen määrä on mahdollista saada selville.
*/
public class Muistivihko {
    private String nimi;
    private String omistaja;
    private ArrayList<String> muistiinpanot;

    /**
    * Luo uuden muistivihkon.
    * Alustaa uuden listan.
    *
    * @param nimi muistivihkon nimi
    * @param omistaja esim. muistivihkon omistajan nimi
    */
    public Muistivihko(String nimi, String omistaja) {
        this.nimi = nimi;
        this.omistaja = omistaja;
        muistiinpanot = new ArrayList<>();
    }

    /**
    * Palauttaa muistivihkon nimen
    *
    * @return muistivihkon nimi
    */
    public String getNimi() {
        return nimi;
    }

    /**
    *Asettaa muistivihkon nimen
    *
    * @param nimi muistivihkon nimi
    */
    public void setNimi(String nimi) {
        this.nimi = nimi;
    }

    /**
    * Palauttaa muistivihkon omistajan nimen
    *
    * @return omistajan nimi
    */
    public String getOmistaja() {
        return omistaja;
    }

    /**
    *Asettaa muistivihkon omistajan nimen.
    *
    * @param omistaja omistajan nimi
    */
    public void setOmistaja(String omistaja) {
        this.omistaja = omistaja;
    }

    /**
    * Lisää uuden muistiinpanon muistiinpanojen listaan
    *
    * @param viesti uusi listaan lisättävä muistiinpano
    */
    public void lisaaMuistiinpano(String viesti) {
        this.muistiinpanot.add(viesti);
    }

    /**
    * Palauttaa muistiinpanojen määrän
    *
    * @return muistiinpanot -listan koko eli muistiinpanojen määrä
    */
    public int muistiinpanoja() {
        return muistiinpanot.size();
    }

    /**
    * Tulostaa jokaisen muistiinpanon listasta omalle riville
    */
    public void tulostaMuistiinpanot() {
        for(String viesti : muistiinpanot) {
            System.out.println(viesti);
        }
    }
}
