import java.util.ArrayList;

/**
 * Luokka mallintaa muistiinpanovihkoa, jossa jokaisella viholla on vihon nimi
 * ja sen omistajan nimi. Metodi luo merkkijonoista koostuvan listan, joka
 * kuvastaa muistivihkoa. Käyttäjä pystyy lisäämään muistiinpanon ja selailemaan
 * sitä.
 */
public class Muistivihko {
    public static void main(String[] args) {
    }
    public class Vihko {
        private String nimi;
        private String omistaja;
        private ArrayList<String> muistiinpanot;

        /**
         * Luo uuden muistivihon
         * @param nimi muistivihon nimi
         * @param omistaja vihon omistajan nimi
         */
        public Vihko(String nimi, String omistaja) {
            this.nimi = nimi;
            this.omistaja = omistaja;
            muistiinpanot = new ArrayList<>();
        }

        /**
         * Palauttaa vihon nimen
         * @return vihon nimi
         */
        public String getNimi() {
            return nimi;
        }

        /**
         * Asettaa vihon nimen
         * @param nimi vihon nimi
         */
        public void setNimi(String nimi) {
            this.nimi = nimi;
        }

        /**
         * Palauttaa omistajan nimen
         * @return omistajan nimi
         */
        public String getOmistaja() {
            return omistaja;
        }

        /**
         * Asettaa omistajan nimen
         * @param omistaja omistajan nimi
         */
        public void setOmistaja(String omistaja) {
            this.omistaja = omistaja;
        }

        /**
         * Lisää uuden muistiinpanon
         * @param viesti lisättävä muistiinpano
         */
        public void lisaaMuistiinpano(String viesti) {
            this.muistiinpanot.add(viesti);
        }

        /**
         * Palauttaa numerona tiedon siitä, kuinka monta merkkiä
         * muistiinpanossa on
         * @return numero, joka kertoo muistiinpanon koon
         */
        public int muistiinpanoja() {
            return muistiinpanot.size();
        }

        /**
         * Tulostaa muistiinpanot käyttäjälle
         */
        public void tulostaMuistiinpanot() {
            for (String viesti : muistiinpanot) {
                System.out.println(viesti);
            }
        }
    }
}
