import pygame

def alusta():
    """ Alustaa pygame ikkunan ja palauttaa näyttöolion """
    pygame.init()
    naytto = pygame.display.set_mode((640, 480))
    return naytto

def piirra_pallo(naytto, x: int, y: int):
    """ Piirtää ruudulle pallon annettuihin koordinaatteihin """
    # Parametrit: näyttöolio, väri (r,g,b), x- ja y-koordinaatit
    # tuplena, koko x-suunnassa, koko y-suunnassa
    pygame.draw.circle(naytto, (255,0,0), (x, y), 40, 40)
    
def piirra_suorakulmio(naytto, x, y, leveys, korkeus):
    """ Piirtää ruudulle annetun kokoisen suorakulmion """
    # Mitat annetaan Rect-oliona
    pygame.draw.rect(naytto, (0,255,0), pygame.Rect(x, y, leveys, korkeus))

def piirra_viiva(naytto, alku_x, alku_y, loppu_x, loppu_y):
    """ Piirtää ruudulle viivan annettujen koordinaattien väliin """
    # Sekä alku- että loppukoordinaatit annetaan tuplena
    pygame.draw.line(naytto, (255,255,255), (alku_x,alku_y), (loppu_x,loppu_y))



naytto = alusta()
naytto.fill((0,0,0))
piirra_pallo(naytto, 320, 200)
piirra_suorakulmio(naytto, 50,50, 200, 150)
piirra_viiva(naytto, 0, 0, 640, 480)

# tämä piirtää ruuduun uudestaan muutosten jälkeen
pygame.display.flip()

# Pygamen pääsilmukka, jossa odotetaan ikkunan sulkeutumista
while True:
    for tapahtuma in pygame.event.get():
        if tapahtuma.type == pygame.QUIT:
            exit()
