#!/bin/bash

if [ "$#" -ne 3 ]; then
	echo "Usage: $0 stop_code freq_secs video_source" >&2
	echo "  stop_code: string identifier for the stop (f.ex. T35)" >&2
	echo "  freq_secs: in seconds how often the python script is invoked (does not account for ca. 2 seconds of processing time)" >&2
	echo "  video_source: numeric index of the OpenCV video source" >&2
	exit 1
fi

if [ "$2" -lt 3 ] 2>/dev/null; then
	echo "freq_secs must be larger than or equal to 3" >&2
	exit 1
fi

if [ "$3" -lt 0 ] 2>/dev/null; then
	echo "video_source must be larger than or equal to 0" >&2
	exit 1
fi

while true
do
	python "./sbs_client.py" "$1" $3
	ret=$?
	if [ $ret -ne 0 ]; then
		exit 1
	fi
	sleep $2
done
