# -*- coding: utf-8 -*-
"""
Created on Tue Feb 20 21:33:57 2018

@author: veskuh
"""

import cv2
import requests
from requests_toolbelt.multipart.encoder import MultipartEncoder
import os

# Image file name and location
image = ".\images\image.jpg"


# Sending image to server
def sendImage():
    # Send local image file to tensorflow-client 
    multipart_data = MultipartEncoder(
    fields={
        # a file upload field
        "image": ("image.jpg", open(image, "rb"), "image/jpg"),
        "stop_code": "Test"
       }
    )
    
    response = requests.post("http://tensorflow.stop.capstone.utu.fi/api/v1/classifyImage/", data=multipart_data,
              headers={"Content-Type": multipart_data.content_type})

# Removing image for security purposes 
def removeImage():
    os.remove(image)

# Taking a picture from default webcam and saving it
def takePicture():
    cap = cv2.VideoCapture(0)
    
    ret, frame = cap.read()

    cv2.imwrite(image,frame)
    cap.release()

takePicture()
sendImage()
removeImage()