# coding=utf-8

import pytz

from jinja2.ext import Extension

from dateutil.tz import tzlocal
from datetime import datetime

from .dataHandler import formatSeconds, loadJson

# this exist purely for the benefit of pybabel
# normally you would add functions through flask
class CustomFunctionsExtension(Extension):
	def __init__(self, environment):
		Extension.__init__(self, environment)

		environment.globals['load_json'] = loadJson
		environment.globals['format_seconds'] = formatSeconds
		environment.globals['server_time'] = self._serverTime
		environment.filters['formatseconds'] = formatSeconds

	def _serverTime(self, isoDate = True, tz = None):
		currentTime = datetime.now(tzlocal()).replace(microsecond = 0)
		if tz:
			currentTime = currentTime.astimezone(pytz.timezone(tz))
		if isoDate:
			return currentTime.isoformat()

		return currentTime
