## Frontend Server instructions for Development

### Testing without docker

1. Optional: set up a virtual environment using virtualenv (or virtualenvwrapper),
both can be installed using pip. Note that if you use virtualenvwrapper on windows
the package name is `virtualenvwrapper-win` also if ran from Windows Git Bash
(msysgit etc.) you may need to append the commands with .bat for them to work.
2. Download the Föli GTFS package from <http://data.foli.fi/gtfs/gtfs.zip> and 
extract it under `data/gtfs`.
3. Install Flask and run the server from **this** directory with the following
commands

```shell
$ pip install -r requirements.txt
$ python -m server -P <port> -H <host> -d [-p]
```

Running the second command with no arguments will bind to localhost at port 5000
with debugging features disabled. Running with the -d switch (for debug) during
development is recommended for meaningful error reporing. Debugging allows running
arbitrary python code from browser, so it should never be used on public instances.

Using the -p switch (note case sensitivity) will enabled Werkzeug middleware request
profiler. This must be used with the debug switch also enabled, without it has not
impact.

### Using docker to test changes locally

1. Install docker or docker toolbox (Windows 10 Home or "worse")
2. To test the server through docker locally use the following commands

```shell
# build and run the container, exposing port 80 at physical port 80
$ docker build -t smartbusstop:latest .
$ docker run -p 80:80 -it --name=smartbusstop smartbusstop:latest

# to see your running container instance use (in a different terminal)
$ docker ps

# to access a shell from your running container instance use
$ docker exec -it smartbusstop bash

# to remove a container (after it has been stoped, ie. Ctrl+C)
$ docker rm smartbusstop

# to (re)start or stop the container you created with run use
$ docker start smartbusstop
$ docker stop smartbusstop

# see any images you have currently built
$ docker images

# remove built images with
$ docker rmi <image_id_or_name>
```

The docker container is based on the `nginx:latest` docker that pulls in a slim
debian, it installs python 2.7 (Google transitfeed library for parsing GTFS data
does not support python 3 as of now, otherwise the application supports both
versions of python) and [supervisor](http://supervisord.org/) to run both nginx
and the Flask application inside the same container. The configuration files for
Supervisor and Nginx can be found in the conf directory. Nginx acts as a basic
reverse proxy to let us reap the performance benefits from it for static files.

Docker image will include the most recent GTFS data from 
`http://data.foli.fi/gtfs/gtfs.zip` at the time of its build and will use it as
the applications data source for stop and static schedule information.

While it is possible to get shell access to running container through `docker exec`
it is important to note that any actions taken through this kind of shell do not
persist across containers.

### Deploying changes

In order to deploy changes to [stop.capstone.utu.fi](http://stop.capstone.utu.fi/) 
you can just merge `master` branch into `deploy` and a new image is built and pushed
into the gitlab container registry followed by upgrading the running instance on
rancher through its web hook with the magic of gitlab CI.

The deploy branch **can not** be pushed to directly using command line tools, as
it is protected in such a way, so make a merge request and accept it, to trigger a
deploy, using gitlab web interface.

## About the Flask Application (WIP)

It will respond to requests based on which templates exist in the templates
directory, excluding any templates placed in the internal sub directory.

When rendering a template, a json data file matching the path of the template is
automatically loaded into the Jinja template context, from the data directory,
as variables such that any first level member from the json object in the file
is set as template variable. The root of the data file **must** be an object not
a list (array).

Additional data files can be loaded with the template function `load_json(path)`
using the [with](http://jinja.pocoo.org/docs/2.10/templates/#with-statement) or
[set](http://jinja.pocoo.org/docs/2.10/templates/#assignments) statements of
Jinja templating engine.

In order to run the application in "kiosk" mode append the URL opened with the 
`ref=kiosk[...]` query string argument. As long as JavaScript can not be disabled or
the url change the application will run with certain features enabled that make it
harder to access unintended content through it. The ref argument can contain any
alphanumeric characters underscores or dashes after the word kiosk for logging
purposes. The ref argument is also preserved for all internal ajax calls. 

### Javascript json endpoints (tentative)

#### Stop Information

```
URI: /api/v1/info/<stopId>
Data Source: http://data.foli.fi/gtfs/gtfs.zip
Returns: JSON object corresponding to the provided stop code ammended with the
stop_url field.
```

#### Data Files

```
URI: URI: /api/v1/data/[<stopId>/]<path>.json
Data Source: data directory
Returns: the corresponding data file, if stopCode is provided files specific to
that GTFS stop_code will have priority.
```
